<?php
include("includes/session.php");
include("../private/pdo.php");
if (isset($_POST) && !empty($_POST)) { // Si la variable POST est présente et non vide
    function pseudoExist($pseudo, $pdo)
    {
        $query = $pdo->prepare("SELECT pseudo FROM users WHERE pseudo = :pseudo");
        $query->bindValue(":pseudo", $pseudo, PDO::PARAM_STR);
        $query->execute();
        return $query->fetch();
    }

    function emailExist($email, $pdo)
    {
        $pseudo_query = $pdo->prepare("SELECT EMAIL FROM users WHERE EMAIL = :email");
        $pseudo_query->bindValue(":email", $email, PDO::PARAM_STR);
        $pseudo_query->execute();
        return $pseudo_query->fetch();
    }

    $pseudo = (isset($_POST["pseudo"]) && !empty($_POST["pseudo"] && is_string($_POST["pseudo"]))) ? $_POST["pseudo"] : null; // On récupère la variable passé dans POST pour le pseudo en testant si elle est pas vide et si c'est bien un string
    $password = (isset($_POST["password"]) && !empty($_POST["password"]) && is_string($_POST["password"])) ? $_POST["password"] : null; // On récupère la variable passé dans POST pour le mot de passe en testant si elle est pas vide et si c'est bien un string
    $email = (isset($_POST["email"]) && !empty($_POST["email"]) && is_string($_POST["email"])) ? $_POST["email"] : null; // On récupère la variable passé dans POST pour l'email en testant si elle est pas vide et si c'est bien un string
    $name = (isset($_POST["name"]) && !empty($_POST["name"]) && is_string($_POST["name"])) ? $_POST["name"] : null; // On récupère la variable passé dans POST pour le nom en testant si elle est pas vide et si c'est bien un string
    $lastname = (isset($_POST["lastname"]) && !empty($_POST["lastname"]) && is_string($_POST["lastname"])) ? $_POST["lastname"] : null; // On récupère la variable passé dans POST pour le nom de famille en testant si elle est pas vide et si c'est bien un string
    $registed = false;
    $errors = array();
    if ($pseudo != null && $password != null && $email != null && $lastname != null) {
        if (!empty($password)) { // Si le mot de passe est vide
            if (strlen($password) < 8) { // La taille du mot de passe est inférieure à 8
                $errors[] = "Le mot de passe est trop court !";
            }
        } else {
            $errors[] = "Le mot de passe est vide !";
        }
        if (!empty($pseudo)) {
            if (pseudoExist($pseudo, $pdo)) {
                $errors[] = "Ce pseudo est déjà utilisé !";
            }
            if (strlen($pseudo) < 4) {
                $errors[] = "Le pseudo est trop court ! Le pseudo doit faire plus de 4 caractères.";
            }
        } else {
            $errors[] = "Le pseudo doit être spécifié !";
        }
        if (!empty($email)) {
            if (emailExist($email, $pdo)) {
                $errors[] = "Cet email est déjà utilisé !";
            }
        } else {
            $errors[] = "L'email doit être spécifié !";
        }
        if (empty($lastname)) {
            $errors[] = "Le nom de famille n'est pas spécifié !";
        }
        if (count($errors) == 0) {
            $query = $pdo->prepare("INSERT INTO users (pseudo, password, email, name, lastname) VALUES (:pseudo, :password, :email, :name, :lastname)");
            if ($query) {
                $query->bindValue(":pseudo", $pseudo, PDO::PARAM_STR);
                $query->bindValue(":password", password_hash($password, PASSWORD_DEFAULT), PDO::PARAM_STR);
                $query->bindValue(":email", $email, PDO::PARAM_STR);
                $query->bindValue(":name", $name, PDO::PARAM_STR);
                $query->bindValue(":lastname", $lastname, PDO::PARAM_STR);
                if ($query->execute()) {
                    $sess_id = $_SESSION["id"] = $pdo->lastInsertId();
                    $sess_rank = $_SESSION["rank"] = 1;
                    $registed = true;
                } else {
                    $errors[] = "Une erreur est survenue.";
                }
            } else {
                $errors[] = "Une erreur est survnenu.";
            }
        }
    } else {
        $errors[] = "Tous les champs obligatoires ne sont pas rempli !";
    }
}

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <?php
    $title = "Inscription";
    include("includes/head.php");
    ?>
</head>
<body>
<header>
    <?php include("includes/header.php"); ?>
    <link rel="stylesheet" href="/css/form.css">
</header>
<section>
    <div id="register-container">
        <div class="form_container">
            <span class="form_title">Inscription</span>
            <div class="form_messages">
                <?php if (isset($errors)) foreach ($errors as $err) {
                    echo "<span class=\"error\">$err</span>";
                }
                if (isset($registed) && $registed) echo "<span class=\"good\">Vous êtes maintenant inscrits.<br/>Bienvenue $pseudo !</span>"; ?>
            </div>
            <form method="post">
                <div class="form_input input_container">
                    <label for="pseudo">Pseudo : *</label>
                    <input type="text" id="pseudo" name="pseudo" required>
                </div>
                <div class="form_input input_container">
                    <label for="password">Mot de passe : *</label>
                    <input type="password" id="password" name="password" required>
                </div>
                <div class="form_input input_container">
                    <label for="email">Email : *</label>
                    <input type="email" id="email" name="email" required>
                </div>
                <div class="form_input input_container">
                    <label for="name">Prénom : </label>
                    <input type="text" id="name" name="name">
                </div>
                <div class="form_input input_container">
                    <label for="lastname">Nom de famille : *</label>
                    <input type="text" id="lastname" name="lastname">
                </div>
                <input class="form_submit btn" type="submit" value="Register">
            </form>
        </div>
    </div>
</section>
<footer>
    <?php include("includes/footer.php"); ?>
</footer>
<?php include("includes/scripts.php"); ?>
</body>
</html>