<?php
include("includes/session.php");
include("../private/pdo.php");
if (isset($_POST) && !empty($_POST)) { // Si la variable POST est présente et non vide
    $pseudo = (isset($_POST["pseudo"]) && !empty($_POST["pseudo"] && is_string($_POST["pseudo"]))) ? $_POST["pseudo"] : null; // On récupère la variable passé dans POST pour le pseudo en testant si elle est pas vide et si c'est bien un string
    $password = (isset($_POST["password"]) && !empty($_POST["password"]) && is_string($_POST["password"])) ? $_POST["password"] : ""; // On récupère la variable passé dans POST pour le mot de passe en testant si elle est pas vide et si c'est bien un string
    $error = true;
    if ($pseudo != null && $password != null) {
        $query = $pdo->prepare("SELECT * FROM users WHERE pseudo = :pseudo OR email = :pseudo");
        $query->bindValue(":pseudo", $pseudo, PDO::PARAM_STR);
        if ($query->execute()) {
            $data = $query->fetch();
            if (password_verify($password, $data["PASSWORD"])) {
                $sess_id = $_SESSION["id"] = (int) $data["id"];
                $sess_rank = $_SESSION["rank"] = (int) $data["RANK"];
                $error = false;
                header("Location: /");
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">

<head>
    <?php
    $title = "Connexion";
    include("includes/head.php");
    ?>
</head>

<body>
<header>
    <?php include("includes/header.php"); ?>
    <link rel="stylesheet" href="/css/form.css">
</header>

<section>
    <div id="connexion-container">
        <div class="form_container">
            <span class="form_title">Connexion</span>
            <div class="form_messages">
                <?php if (isset($error)) echo "<span class=\"error\">Pseudo/Email ou mot de passe incorrect !</span>"; ?>
            </div>
            <form method="post" id="formLogin">
                <div class="form_input input_container">
                    <label for="pseudo">Pseudo/Email : </label>
                    <input type="text" id="pseudo" name="pseudo" required>
                </div>
                <div class="form_input input_container">
                    <label for="password">Mot de passe : </label>
                    <input type="password" id="password" name="password" required>
                </div>
                <input class="form_submit btn" type="submit" value="Connexion">
            </form>
        </div>
    </div>
</section>

<footer>
    <?php include("includes/footer.php"); ?>
</footer>
<?php include("includes/scripts.php"); ?>

<script type="text/javascript" src="/js/login.js"></script>

</body>

</html>