/* Ajax */
let AJAX;

/**
 * Create a new Ajax request
 * @param method : string
 * @param url : string
 * @param data : Array, JSON, FormData -> Double Array [[names], [values]], JSON object {name: [], value: []}
 * @param loadendCallbackFn : function
 * @param token : boolean
 * @param send : boolean
 * @constructor
 */
Ajax = function (method, url, data, loadendCallbackFn, token, send) {
    AJAX = this;
    this.method = (method !== undefined && method !== null && typeof method === "string") ? method.toUpperCase() : "";
    this.url = (url !== undefined && url !== null && typeof url === "string") ? url : "";
    this.data = this._setData(data);
    this.loadend = (loadendCallbackFn !== undefined && loadendCallbackFn !== null && typeof loadendCallbackFn === "function") ? loadendCallbackFn : () => {
    };
    this.token = (token !== undefined && token !== null && typeof token === "boolean") ? token : false;
    this.send = (send !== undefined && send !== null && typeof send === "boolean") ? send : false;
    this.xhttpRequest = new XMLHttpRequest();
    this._init();
};

Ajax.prototype = {
    /**
     * Transform data for have FormData
     * @param data : {FormData|Array|JSON}
     * @returns {FormData}
     * @private
     */
    _setData: function (data) {
        if (typeof data === "object") {
            if (data instanceof FormData) return data;
            else if (data instanceof Array) {
                let d = new FormData();
                for (let i = 0; i < data[0].length; i++) d.append(data[0][i], data[1][i]);
                return d;
            } else {
                try {
                    data = JSON.parse(data);
                    let d = new FormData();
                    for (let i = 0; i < data.name[0].length; i++) d.append(data.name[i], data.value[i]);
                    return d;
                } catch (e) {
                    return new FormData();
                }
            }
        } else return new FormData();
    },
    /**
     * Initialise ajax request
     * @private
     */
    _init: function () {
        this._addEvent("loadend", this.loadend, false);
        this._addEvent("loadend", (event) => {
            this.responseText = event.target.responseText;
        }, false);
        if (this.send) {
            this._send();
        }
    },
    /**
     * Send ajax request
     * @public
     */
    _send: function () {
        this.xhttpRequest.open(this.method, this.url, true);
        if (this.token) this.data.append("token", token);
        this.xhttpRequest.send(this.data);
    },
    /**
     * Add event to ajax request
     * @param event : string
     * @param fn : function
     * @param uploadEvent : boolean
     * @public
     */
    _addEvent: function (event, fn, uploadEvent) {
        uploadEvent = (uploadEvent !== undefined && uploadEvent !== null && typeof uploadEvent === "boolean") ? uploadEvent : false;
        if (uploadEvent) {
            this.xhttpRequest.upload.addEventListener(event, fn, false);
        } else {
            this.xhttpRequest.addEventListener(event, fn, false);
        }
    },
    /**
     * Return response text of ajax request
     * @returns {*|string}
     * @public
     */
    _getResponseText: function () {
        return this.responseText;
    }
};