<?php
include("../../private/pdo.php");
if (isset($_POST) && !empty($_POST)) {
    if (isset($_POST["action"]) && !empty($_POST["action"])) {
        $action = $_POST["action"];
        switch ($action) {
            case "getAll":
                $query = $pdo->prepare("SELECT * FROM users");
                $query->execute();
                http_response_code(200);
                echo json_encode($query->fetchAll());
                $query->closeCursor();
                return;
                break;
            case "update":
                $id = (isset($_POST["id"]) && !empty($_POST["id"]) && is_string($_POST["id"])) ? $_POST["id"] : null;
                $query = $pdo->prepare("SELECT RANK FROM users WHERE id = :id");
                $query->bindValue(":id", $id, PDO::PARAM_INT);
                if ($query->execute()) {
                    if ($data = $query->fetch()) {
                        $query->closeCursor();
                        $query = $pdo->prepare("UPDATE users SET RANK = :rank WHERE id = :id");
                        $query->bindValue(":id", $id, PDO::PARAM_INT);
                        $query->bindValue(":rank", ($data["RANK"] == 1 ? 2 : 1), PDO::PARAM_INT);
                        if ($query->execute()) {
                            http_response_code(200);
                            return;
                        }
                    }
                }
                http_response_code(500);
                return;
                break;
            default:
                http_response_code(404);
                return;
        }
    }
}
http_response_code(500);
return;