<?php
include("includes/session.php");
if ($sess_id != 0 && $sess_rank > 1) {
    ?>
    <!DOCTYPE html>
    <html lang="fr">

    <head>
        <?php
        $title = "Administration";
        include("includes/head.php");
        ?>
    </head>

    <body>
    <header>
        <?php include("includes/header.php"); ?>
    </header>
    <section>
        <div id="manager-container">
            <div id="member-manager">
                <select></select>
                <button class="btn" onclick="switchMemberStatus()">Switch le status</button>
            </div>
        </div>
    </section>
    <footer>
        <?php include("includes/footer.php"); ?>
    </footer>
    <?php include("includes/scripts.php"); ?>
    <script>
        const memberManager_div = document.querySelector("div#member-manager");

        window.addEventListener("DOMContentLoaded", () => {
            displayMember();
        });

        function displayMember() {
            new Ajax("post", "/ajax/member.php", [
                ["action"],
                ["getAll"]
            ], (event) => {
                if (event.target.status === 200) {
                    try {
                        let response = JSON.parse(event.target.responseText);
                        memberManager_div.querySelector("select").innerHTML = "";
                        memberManager_div.querySelector("select").innerHTML += "<option value='null'>Choisir un membre</option>";
                        Array.from(response).forEach((elm) => {
                            memberManager_div.querySelector("select").innerHTML += `<option value="${elm.id}">${elm.PSEUDO} - ${elm.RANK === "1" ? "Membre" : "Administrateur"}</option>`;
                        });
                    } catch (e) {
                        console.error(e);
                    }
                }
            }, false, true);
        }

        function switchMemberStatus() {
            if (memberManager_div.querySelector("select").value !== "null") {
                new Ajax("post", "/ajax/member.php", [
                    ["action", "id"],
                    ["update", memberManager_div.querySelector("select").value]
                ], (event) => {
                    if (event.target.status === 200) {
                        displayMember();
                    }
                }, false, true);
            }
        }

    </script>
    </body>

    </html>
    <?php
} else header("Location: /");
?>
