<?php
include("includes/session.php");
if ($sess_rank > 1) { ?>
    <!DOCTYPE html>
    <html lang="fr">
    <head>
        <?php
        $title = "Ajouter des photos";
        include("includes/head.php");
        ?>
        <link rel="stylesheet" href="/css/form.css">
    </head>
    <body>
    <header>
        <?php include("includes/header.php"); ?>
    </header>
    <section>
        <div class="EventAndPhoto">
        <div id="add_photos" class="form_container">
            <span class="form_title">Ajouter une photo</span>
            <div class="form_messages"></div>
            <form method="post">
                <div class="form_input input_container">
                    <label for="name">Nom de la photo</label>
                    <input type="text" id="name" name="name" placeholder="Nom de la photo ...">
                </div>
                <div class="form_input input_container">
                    <label for="desc">Description</label>
                    <textarea id="desc" name="desc" placeholder="Description de la photo"></textarea>
                </div>
                <div class="form_input input_container">
                    <label for="input_photo">Photo</label>
                    <input type="file" id="input_photo" name="photo">
                </div>
                <input class="form_submit btn" type="button" value="Ajouter" onclick="sendNewPhotos()">
            </form>
        </div>
            </div>
    </section>
    <footer>
        <?php include("includes/footer.php"); ?>
    </footer>
    <?php include("includes/scripts.php"); ?>
    <script>
        const addPhotos_div = document.querySelector("div#add_photos");

        function sendNewPhotos() {
            let name = addPhotos_div.querySelector("form input#name").value;
            let desc = addPhotos_div.querySelector("form textarea#desc").value;
            let photo = addPhotos_div.querySelector("form input#input_photo").files[0];
            new Ajax("post", "/ajax/galerie.php", [["action", "name", "desc", "photo"], ["add", name, desc, photo]], (event) => {
                if (event.target.status === 200) addPhotos_div.querySelector("form").reset();
                    else alert("Une erreur est survenue !");
            }, false, true);
        }
    </script>
    </body>
    </html>
<?php } else {
    http_response_code(404);
}