import re  # Import de la bibliothèque d'expressions régulières


# Fonction qui retourne la requête SQL
def get_insert_sql_request(adresse_ip, jourheure, url):
    return "INSERT INTO PROXY (ma_Sequence.nextVal, '" + adresse_ip + "', '" + jourheure + "', '" + url + "');\n"


# Fonction qui retourne les données récupérées par la ligne de log
def get_info_in_line(ligne, jour):
    adresse_ip = re.search(r"[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}", ligne).group()  # Recherche de l'adresse IP
    heure = jour[-2:len(jour)] + "-" + jour[5:7] + "-" + jour[0:4] + " " + re.search(r"^..:..:..", ligne).group()  # Recherche de l'heure et ajout de la date
    url = re.search(r"https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{2,256}\.[a-z]{2,6}\/", ligne).group()  # Recherche de l'URL
    return {"ip": adresse_ip, "time": heure, "url": url}  # Envoie des données dans un dictionnaire


logFile = input("Nom du fichier log (log_proxy_yyyy-mm-dd.txt) : ")  # Demande le fichier log
date = re.search(r"....-..-..", logFile).group()  # Recherche de la date du fichier
fileName = "log_proxy_" + date + ".txt"  # Création du nom du fichier de log
file = open(fileName, "r")  # Ouverture du fichier de log
sqlName = "insert_" + date + ".sql"  # Création du nom du fichier SQL
fileSQL = open(sqlName, "x")  # Création du fichier sql
for line in file:  # Boucle qui lis toutes les lignes du fichier
    data = get_info_in_line(line, date)  # Je récupère les infos de la ligne
    fileSQL.write(get_insert_sql_request(data["ip"], data["time"], data["url"]))  # J'écrit dans le fichier la requête
file.close()  # Fermeture du fichier log
fileSQL.close()  # Fermeture du fichier SQL
