import os  # Import de la bibliothèque pour le système d'exploitation
import re  # Import de la bibliothèque d'expressions régulières
import tkinter  # Import de la bibliothèque graphique
import tkinter.messagebox  # Import de la bibliothèque pour les fenêtres d'alertes
import tkinter.filedialog  # Import de la bibliothèque pour l'import des fichiers

__dirname__ = os.path.dirname(os.path.abspath(__file__))  # Chemin du dossier du script


class Window:
    def __init__(self, size, title):
        self.tk = tkinter.Tk()
        self.width = size[0]
        self.height = size[1]
        self.title = title
        self.save_path = __dirname__
        self.saved_elm = {"btn": [], "check": [], "text": [], "entr": []}

    def display(self):
        self.tk.title(self.title)
        self.tk.geometry(str(self.width) + "x" + str(self.height))
        self.tk.mainloop()

    def Text(self, inserted_text, font_size, save):
        text = tkinter.Label(self.tk, text=inserted_text, font=("Montserrat", font_size))
        if save[0]:
            txt = save[1]
            txt["this"] = text
            self.saved_elm["text"].append(txt)
        text.pack()

    def CheckBox(self, inserted_text, font_size, save):
        check_box = tkinter.Checkbutton(self.tk, text=inserted_text, font=("Montserrat", font_size))
        if save[0]:
            value = tkinter.IntVar()
            check_box.config(variable=value)
            check = save[1]
            check["this"] = check_box
            check["value"] = value
            self.saved_elm["check"].append(check)
        check_box.pack()

    def Button(self, inserted_text, save, fn):
        button = tkinter.Button(self.tk, text=inserted_text, command=fn)
        button.pack()

    def Entry(self, inserted_text, save):
        entry = tkinter.Entry(self.tk)
        value = tkinter.StringVar()
        if len(inserted_text) > 0:
            value.set(inserted_text)
        if save[0]:
            entr = save[1]
            entr["this"] = entry
            entr["value"] = value
            self.saved_elm["entr"].append(entr)
        entry.config(textvariable=value)
        entry.pack()

    def getVar(self, var):
        return self.saved_elm[var]

    def changeSavePath(self):
        self.save_path = tkinter.filedialog.askdirectory(initialdir=self.save_path, title="Choisir le dossier de destination")
        if len(self.save_path) > 0:
            for txt in self.getVar("text"):
                if txt["name"] == "text_save_path":
                    txt["this"].config(text=self.save_path)
                    txt["this"].pack()
                    break


# Fonction qui retourne la requête SQL
def get_insert_sql_request(adresse_ip, jourheure, url):
    return "INSERT INTO PROXY VALUES (ma_Sequence.nextVal, '" + adresse_ip + "', '" + jourheure + "', '" + url + "');\n"


# Fonction qui retourne les données récupérées par la ligne de log
def get_info_in_line(ligne, jour):
    adresse_ip = re.search(r"[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}", ligne).group()  # Recherche de l'adresse IP
    heure = jour[-2:len(jour)] + "-" + jour[5:7] + "-" + jour[0:4] + " " + re.search(r"^..:..:..", ligne).group()  # Recherche de l'heure et ajout de la date
    url = re.search(r"https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{2,256}\.[a-z]{2,6}\/", ligne).group()  # Recherche de l'URL
    return {"ip": adresse_ip, "time": heure, "url": url}  # Envoie des données dans un dictionnaire


# Procédure qui écrit dans le fichier sql d'après un fichier log
def write_info_in_file(log_file, sql_file, date):
    for line in log_file:  # Pour toute les lignes du fichier
        data = get_info_in_line(line, date)  # Je récupère les infos de la ligne
        sql_file.write(get_insert_sql_request(data["ip"], data["time"], data["url"]))  # J'écrit dans le fichier la requête


# Fonction qui regarde si le fichier contient bien une extension
def has_extension(name_file, ext):
    if ext == "TXT":  # Si on recherche un fichier texte
        if not re.search(r"\.txt$", name_file):  # Si le nom ne contient pas "txt" à la fin
            name_file = name_file + ".txt"  # Je lui rajoute son extension voulu
        return name_file  # Je renvoie son nouveau nom
    if ext == "SQL":  # Si on cherche un fichier sql
        if not re.search(r"\.sql$", name_file):  # Si le nom de contient pas "sql" à la fin
            name_file = name_file + ".sql"  # Je lui rajoute son extension voulu
        return name_file  # Je renvoie son nouveau nom


# Fonction qui remplace les caractères générique que l'on peut peut être retrouver dans les nom des fichier si en contiennent
def replace_generic_char(string, nb_char):
    if "*" in string:  # Si le string contient le caractère "*"
        string = "[0-9]{" + str(nb_char) + "}"  # Alors je le change pour mon expression régulière
    elif "?" in string:  # Si le string contient le caractère "?"
        string = string.replace("?", ".")  # Alors je le change pour mon expression régulière
    return string  # Je retourne le string


def generate():
    check_box = window.getVar("check")
    entr = window.getVar("entr")
    files = []
    for check in check_box:
        if check["value"].get():
            files.append(check["name"])
    for entry in entr:
        if entry["name"] == "sql_file_name":
            entr = entry
            break
    if len(entr["value"].get()) > 0:
        sql_file_name = has_extension(entr["value"].get(), "SQL")
        sql_file_name = window.save_path + "/" + sql_file_name
        if len(files) > 0:
            if tkinter.messagebox.askyesno("Confirmation", "Vous allez générer le fichier SQL ! Le voulez-vous vraiment ?"):
                fileSQL = open(sql_file_name, "x")
                for file in files:
                    fileName = has_extension(file, "TXT")
                    log_date = re.search(r"....-..-..", fileName).group()
                    log_file = open(fileName, "r")
                    write_info_in_file(log_file, fileSQL, log_date)
                    log_file.close()
                fileSQL.close()
                txts = window.getVar("text")
                for txt in txts:
                    if txt["name"] == "done_text":
                        text = txt
                        break
                text["this"].config(text="Fichier généré ! -> insert_proxy.sql")
                text["this"].pack()
                tkinter.messagebox.showinfo("Terminé", "Fichier généré ...")
        else:
            tkinter.messagebox.showerror("Erreur !", "Aucun fichier sélectionné !")
    else:
        tkinter.messagebox.showerror("Erreur !", "Le nom du fichier SQL ne contient aucun caractère !")


window = Window([500, 500], "SQL Generator 2000")
window.Text("Bienvenue sur SQL Generator 2000 !", 20, [False])
window.Text("", 18, [True, {"name": "done_text"}])
window.Text("Veuillez choisir les log voulu : ", 16, [False])
for file in os.listdir(__dirname__):
    if re.search(r"log_proxy_....-..-...txt", file):
        window.CheckBox(file, 15, [True, {"name": file}])
window.Text("", 18, [False])
window.Text(__dirname__, 12, [True, {"name": "text_save_path"}])
window.Button("Changer le chemin d'enregistrement du fichier SQL", [False], window.changeSavePath)
window.Text("Nom du fichier SQL : ", 16, [False])
window.Entry("insert_sql", [True, {"name": "sql_file_name"}])
window.Button("Générer ...", [False], generate)
window.display()
