import collections  # Import de la bibliothèque des collections
import re  # Import de la bibliothèque d'expressions régulières
import os  # Import de la bibliothèque pour le système d'exploitation
import datetime  # Import de la bibliothèque de date

__dirname__ = os.path.dirname(os.path.abspath(__file__))  # Chemin du dossier du script


# Fonction qui retourne la requête SQL
def get_insert_sql_request(adresse_ip, jourheure, url):
    return "INSERT INTO PROXY VALUES (ma_Sequence.nextVal, '" + adresse_ip + "', '" + jourheure + "', '" + url + "');\n"


# Fonction qui retourne les données récupérées par la ligne de log
def get_info_in_line(ligne, jour):
    adresse_ip = re.search(r"[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}", ligne).group()  # Recherche de l'adresse IP
    heure = jour + " " + re.search(r"^..:..:..", ligne).group()  # Recherche de l'heure et ajout de la date
    url = re.search(r"https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{2,256}\.[a-z]{2,6}\b/", ligne).group()  # Recherche de l'URL
    return {"ip": adresse_ip, "time": heure, "url": url}  # Envoie des données dans un dictionnaire


# Procédure qui écrit dans le fichier sql d'après un fichier log
def write_info_in_file(log_file, sql_file, date):
    for line in log_file:  # Pour toute les lignes du fichier
        data = get_info_in_line(line, date)  # Je récupère les infos de la ligne
        sql_file.write(get_insert_sql_request(data["ip"], data["time"], data["url"]))  # J'écrit dans le fichier la requête


# Fonction qui regarde si le fichier contient bien une extension
def has_extension(name_file, ext):
    if ext == "TXT":  # Si on recherche un fichier texte
        if not re.search(r".txt$", name_file):  # Si le nom ne contient pas "txt" à la fin
            name_file = name_file + ".txt"  # Je lui rajoute son extension voulu
        return name_file  # Je renvoie son nouveau nom
    if ext == "SQL":  # Si on cherche un fichier sql
        if not re.search(r".sql$", name_file):  # Si le nom de contient pas "sql" à la fin
            name_file = name_file + ".sql"  # Je lui rajoute son extension voulu
        return name_file  # Je renvoie son nouveau nom


def getAllLogFile():
    files = []
    for file in os.listdir(__dirname__):
        if re.search(r"....-..-..", file):
            files.append(file)
    return files


print("Programmes : \n")
print("1. Nombres de visites par site internet")
print("2. Nombres de visites par adresse IP")
print("3. Recherche des adresses IP par site et entre deux dates")
choice = int(input("Votre choix : "))

if choice == 1:
    urls = {}
    for file in getAllLogFile():
        date = re.search(r"....-..-..", file).group()  # Récupération de la date dans le nom du fichier log
        file = open(file, "r")
        for line in file:
            data = get_info_in_line(line, date)
            if data["url"] in urls:
                urls[data["url"]] = urls.get(data["url"]) + 1
            else:
                urls[data["url"]] = 1
        file.close()
    urls = collections.OrderedDict(sorted(urls.items(), reverse=True, key=lambda t: t[1]))
    for value in urls:
        print(value, ":", urls[value])
elif choice == 2:
    ips = {}
    for file in getAllLogFile():
        date = re.search(r"....-..-..", file).group()  # Récupération de la date dans le nom du fichier log
        file = open(file, "r")
        for line in file:
            data = get_info_in_line(line, date)
            if data["ip"] in ips:
                ips[data["ip"]] = ips.get(data["ip"]) + 1
            else:
                ips[data["ip"]] = 1
        file.close()
    for value in ips:
        print(value, ":", ips[value])
elif choice == 3:
    search_url = input('Veuillez saisir un site : ')  # Saisie de l'URL voulu
    date_debut = datetime.datetime.strptime(input('Veuillez saisir une date et une heure de départ (yyyy-mm-dd hh24:mm:ss) : '), "%Y-%m-%d %H:%M:%S")  # Saisie de la date de début
    date_fin = datetime.datetime.strptime(input("Veuillez saisir une date et une heure d'arrivée (yyyy-mm-dd hh24:mm:ss) : "), "%Y-%m-%d %H:%M:%S")  #Saisie de la date de fin

    found = []  # Liste de recherche
    for file in os.listdir(__dirname__):  # Pour tout les fichiers du dossier où se trouve le script
        if re.search(r"log_proxy_....-..-..\.txt", file):  # Recherche le nom d'un fichier du type
            date = re.search(r"....-..-..", file).group()  # Récupération de la date dans le nom du fichier log
            date = datetime.datetime.strptime(date, "%Y-%m-%d").date()  # Transformation de la data en un type Datetime
            if date_debut.date() <= date <= date_fin.date():  # Si la date récupérer du fichier est bien entre les 2 dates voulu
                log_file = open(file, "r")  # Ouverture du fichier de log
                for line in log_file:  # Pour toutes les lignes
                    data = get_info_in_line(line, str(date))
                    heure = datetime.datetime.strptime(data["time"], "%Y-%m-%d %H:%M:%S")  # On convertit l'heure en un type Datetime
                    if data["url"] == search_url:  # On test si l'URL est la bonne
                        if date_debut.date() <= heure.date() <= date_fin.date():  # Si l'heure est comprise entre les 2 heures voulu
                            IP = data["ip"]  #  Adresse IP  # On récupère l'adresse IP
                            data = {"ip": IP, "date": date, "heure": heure.time()}  # Création d'un dictionnaire avec les données récupérée
                            found.append(data)  # Insertion des données dans le tableau
                log_file.close()  # On ferme le fichier log ouvert
    if len(found) > 0:  # Si le tableau à du contenu
        for i in range(len(found) - 1):  # On parcourt le tableau
            data = found[i]  # On récupère les données de l'index "i"
            print(data["date"], data["heure"], ":", data["ip"])  # On les affiches
    else:  # Si le tableau est vide
        print("Aucun résultat")  # On indique qu'il n'y a aucune données
else:
    print("Aucun programmes sélectionnés.")
