import re  # Import de la bibliothèque d'expressions régulières
import sys  # Import la bibliothèque système
import os  # Import de la bibliothèque pour le système d'exploitation

__dirname__ = os.path.dirname(os.path.abspath(__file__))  # Chemin du dossier du script


# Fonction qui retourne la requête SQL
def get_insert_sql_request(adresse_ip, jourheure, url):
    return "INSERT INTO PROXY VALUES (ma_Sequence.nextVal, '" + adresse_ip + "', '" + jourheure + "', '" + url + "');\n"


# Fonction qui retourne les données récupérées par la ligne de log
def get_info_in_line(ligne, jour):
    adresse_ip = re.search(r"[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}", ligne).group()  # Recherche de l'adresse IP
    heure = jour[-2:len(jour)] + "-" + jour[5:7] + "-" + jour[0:4] + " " + re.search(r"^..:..:..", ligne).group()  # Recherche de l'heure et ajout de la date
    url = re.search(r"https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{2,256}\.[a-z]{2,6}\/", ligne).group()  # Recherche de l'URL
    return {"ip": adresse_ip, "time": heure, "url": url}  # Envoie des données dans un dictionnaire


# Procédure qui écrit dans le fichier sql d'après un fichier log
def write_info_in_file(log_file, sql_file, date):
    for line in log_file:  # Pour toute les lignes du fichier
        data = get_info_in_line(line, date)  # Je récupère les infos de la ligne
        sql_file.write(get_insert_sql_request(data["ip"], data["time"], data["url"]))  # J'écrit dans le fichier la requête


# Fonction qui regarde si le fichier contient bien une extension
def has_extension(name_file, ext):
    if ext == "TXT":  # Si on recherche un fichier texte
        if not re.search(r".txt$", name_file):  # Si le nom ne contient pas "txt" à la fin
            name_file = name_file + ".txt"  # Je lui rajoute son extension voulu
        return name_file  # Je renvoie son nouveau nom
    if ext == "SQL":  # Si on cherche un fichier sql
        if not re.search(r".sql$", name_file):  # Si le nom de contient pas "sql" à la fin
            name_file = name_file + ".sql"  # Je lui rajoute son extension voulu
        return name_file  # Je renvoie son nouveau nom


# Fonction qui remplace les caractères générique que l'on peut peut être retrouver dans les nom des fichier si en contiennent
def replace_generic_char(string, nb_char):
    if "*" in string:  # Si le string contient le caractère "*"
        string = "[0-9]{" + str(nb_char) + "}"  # Alors je le change pour mon expression régulière
    elif "?" in string:  # Si le string contient le caractère "?"
        string = string.replace("?", ".")  # Alors je le change pour mon expression régulière
    return string  # Je retourne le string


argsLength = len(sys.argv)  # Nombre d'arguments de la commande
sqlFileArg = sys.argv[argsLength - 1]  # Recupération du nom du fichier
if argsLength > 3:  # Je regarde si il y a 1 fichier demandé ou alors plusieurs
    sqlFileArg = has_extension(sqlFileArg, "SQL")  # Je regarde si l'extension est bien là
    fileSQL = open(sqlFileArg, "x")  # Création du fichier sql
    for k in range(argsLength):  # Boucle pour parcourir les arguments de la commande
        if not k == 0 and not k == argsLength - 1:  # Je regarde si ce n'est pas le premier argument de commande, car le premier est le fichier Python et si ce n'est pas le dernier car le dernier est le fichier sql
            fileName = sys.argv[
                k]  # Je récupère l'argument k != 0 (qui est le nom du fichier python) et != du dernier argument (qui est le fichier sql)
            fileName = has_extension(fileName, "TXT")  # Je regarde si l'extension est bien là
            log_date = re.search(r"....-..-..", fileName).group()  # Récupération de la date dans le nom du fichier log
            file = open(fileName, "r")  # Ouverture du fichier de log
            write_info_in_file(file, fileSQL, log_date)  # Appelle de la procédure pour écrire dans le fichier sql
            file.close()  # Fermeture du fichier log
    fileSQL.close()  # Fermeture du fichier SQL
else:
    fileName = has_extension(sys.argv[1], "TXT")  # Je regarde si l'extension est bien là
    SQLName = has_extension(sys.argv[len(sys.argv) - 1], "SQL")  # Je regarde si l'extension est bien là
    SQLFile = open(SQLName, "x")  # J'ouvre le fichier SQL
    if re.search(r"[*?]", fileName):  # Je regarde si le fichier contient des caratères génériques
        log_date = re.search(r".{1,4}-.{1,4}-.{1,4}", fileName).group()  # Récupération de la date dans le nom du fichier log
        fileNameSplit = log_date.split("-")  # Je split pour manipuler la date plus facilement
        fileNameSplit[0] = replace_generic_char(fileNameSplit[0], 4)  # Je test si il à un caractère générique
        fileNameSplit[1] = replace_generic_char(fileNameSplit[1], 2)  # Je test si il à un caractère générique
        fileNameSplit[2] = replace_generic_char(fileNameSplit[2], 2)  # Je test si il à un caractère générique
        new_log_date = r"-".join(fileNameSplit)  # Je fais une nouvelle date
        for file in os.listdir(__dirname__):  # Je parcours les fichiers qui sont dans le même dossier que le script
            if re.search(new_log_date, file):  # Si le fichier correspond au pattern créé auparavant
                file = open(file, "r")  # J'ouvre le fichier log
                log_date = re.search(r"....-..-..", fileName).group()  # Je prends la date du fichier
                write_info_in_file(file, SQLFile, log_date)  #J'écrit les infos contenu dans le fichier log
                file.close()  # Je ferme le fichier log
        SQLFile.close()  # Je ferme le fichier SQL
    else:  # Sinon il n'y a pas de caractère générique donc c'est une requête normal
        log_date = re.search(r"....-..-..", fileName).group()  # Récupération de la date dans le nom du fichier log
        file = open(fileName, "r")  # J'ouvre le fichier log voulu
        write_info_in_file(file, SQLFile, log_date)  # J'écrit dans le fichier sql
        file.close()  # Je ferme le fichier log
        SQLFile.close()  # Je ferme le fichier SQL maintenant créé
