import re  # Import de la bibliothèque d'expressions régulières
import sys  # Import la bibliothèque système


# Fonction qui retourne la requête SQL
def get_insert_sql_request(addresse_ip, jourheure, url):
    return "INSERT INTO PROXY VALUES (ma_Sequence.nextVal, '" + addresse_ip + "', '" + jourheure + "', '" + url + "');\n"


# Fonction qui retourne les données récupérées par la ligne de log
def get_info_in_line(ligne, jour):
    addresse_ip = re.search(r"[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}",
                            ligne).group()  # Recherche de l'adresse IP
    heure = jour[-2:len(jour)] + "-" + jour[5:7] + "-" + jour[0:4] + " " + re.search(r"^..:..:..",
                                                                                     ligne).group()  # Recherche de l'heure et ajout de la date
    url = re.search(r"https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)",
                    ligne).group()  # Recherche de l'URL
    return {"ip": addresse_ip, "time": heure, "url": url}  # Envoie des données dans un dictionnaire


argsLength = len(sys.argv)
sqlFileArg = sys.argv[argsLength - 1]
if not re.search(r".sql$", sqlFileArg):  # Si l'extension du fichier SQL est oubliée
    sqlFileArg = sqlFileArg + ".sql"  # Je la rajoute
fileSQL = open(sqlFileArg, "x")  # Création du fichier sql
for k in range(argsLength):  # Boucle pour parcourir les arguments de la commande
    if not k == 0 and not k == argsLength - 1:  # Je regarde si ce n'est pas le premier argument de commande, car le premier est le fichier Python et si ce n'est pas le dernier car le dernier est le fichier sql
        fileName = sys.argv[k]
        if not re.search(r".txt$", fileName):  # Si l'extension est oubliée
            fileName = fileName + ".txt"  # Je la rajoute
        file = open(fileName, "r")  # Ouverture du fichier de log
        date = re.search(r"....-..-..", fileName).group()  # Récupération de la date dans le nom du fichier log
        for line in file:  # Boucle qui lis toutes les lignes du fichier
            data = get_info_in_line(line, date)  # Je récupère les infos de la ligne
            fileSQL.write(
                get_insert_sql_request(data["ip"], data["time"], data["url"]))  # J'écrit dans le fichier la requête
        file.close()  # Fermeture du fichier log
fileSQL.close()  # Fermeture du fichier SQL
