import re  # Import de la bibliothèque d'expressions régulières
import sys  # Import la bibliothèque système


# Fonction qui retourne la requête SQL
def get_insert_sql_request(adresse_ip, jourheure, url):
    return "INSERT INTO PROXY VALUES (ma_Sequence.nextVal, '" + adresse_ip + "', '" + jourheure + "', '" + url + "');\n"


# Fonction qui retourne les données récupérées par la ligne de log
def get_info_in_line(ligne, jour):
    adresse_ip = re.search(r"[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}", ligne).group()  # Recherche de l'adresse IP
    heure = jour[-2:len(jour)] + "-" + jour[5:7] + "-" + jour[0:4] + " " + re.search(r"^..:..:..", ligne).group()  # Recherche de l'heure et ajout de la date
    url = re.search(r"https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{2,256}\.[a-z]{2,6}\b/", ligne).group()  # Recherche de l'URL
    return {"ip": adresse_ip, "time": heure, "url": url}  # Envoie des données dans un dictionnaire


if not re.search(r".txt$", sys.argv[1]):  # Si l'extension est oubliée
    sys.argv[1] = sys.argv[1] + ".txt"  # Je la rajoute
if not re.search(r".sql$", sys.argv[2]):  # Si l'extension est oubliée
    sys.argv[2] = sys.argv[2] + ".sql"  # Je la rajoute
file = open(sys.argv[1], "r")  # Ouverture du fichier de log demandé
fileSQL = open(sys.argv[2], "x")  # Création du fichier sql
date = re.search(r"....-..-..", sys.argv[1]).group()  # Récupération de la date dans le nom du fichier log
for line in file:  # Boucle qui lis toutes les lignes du fichier
    data = get_info_in_line(line, date)  # Je récupère les infos de la ligne
    fileSQL.write(get_insert_sql_request(data["ip"], data["time"], data["url"]))  # J'écrit dans le fichier la requête
file.close()  # Fermeture du fichier log
fileSQL.close()  # Fermeture du fichier SQL
