public class SquareGame {
  Square playerSquare;
  ArrayList<Obstacle> obstacles;
  boolean started = false, drawScore = false;
  int score, baseMaxCoolDown, maxCoolDown, cooldown, baseObstaclesGameSpeed, obstaclesGameSpeed, bottom;
  Button restartBtn;

  void init() {
    this.playerSquare = new Square();
    this.obstacles = new ArrayList<Obstacle>();
    this.restartBtn = new Button((windowWidth / 2) - 150 / 2, 200, 150, 75, "Rejouer", false);
    this.score = 0;
    this.baseMaxCoolDown = 150;
    this.maxCoolDown = this.baseMaxCoolDown;
    this.baseObstaclesGameSpeed = 5;
    this.obstaclesGameSpeed = this.baseObstaclesGameSpeed;
    this.cooldown = this.baseMaxCoolDown;
    this.bottom = 600;
  }

  void launch() {
    setWindowTitle("Square Game");
    this.start();
  }

  void start() {
    this.started = true;
  }

  void restart() {
    this.reset();
    this.restartBtn.setVisibility(false);
    menuBtn.setVisibility(false);
    this.drawScore = false;
    this.start();
  }

  void reset() {
    this.obstacles.clear();
    this.maxCoolDown = this.baseMaxCoolDown;
    this.cooldown = this.baseMaxCoolDown;
    this.obstaclesGameSpeed = this.baseObstaclesGameSpeed;
    this.score = 0;
    this.playerSquare = new Square();
  }

  void endGame() {
    this.started = false;
    this.drawScore = true;
    this.restartBtn.setVisibility(true);
    menuBtn.setVisibility(true);
  }

  void stop() {
    this.reset();
    this.started = false;
    this.drawScore = false;
    this.restartBtn.setVisibility(false);
  }

  void update() {
    if (this.started) {
      if (this.cooldown < 1) {
        this.obstacles.add(new Obstacle(windowWidth, this.bottom, this.obstaclesGameSpeed, this));
      }
      this.playerSquare.update((keyPressed && (key == ' ') || mousePressed));
      for (int i = 0; i < this.obstacles.size(); i++) {
        if (!this.obstacles.get(i).update()) {
          this.obstacles.remove(i);
          this.updateScore();
        }
      }
      if (this.cooldown > 0) this.cooldown--;
      else this.cooldown = round(random(50, this.maxCoolDown));
    }
    if (this.restartBtn.getVisibility()) {
      if (mousePressed) {
        if (this.restartBtn.isClickOnMe(mouseX, mouseY)) {
          this.restart();
        }
      }
      this.restartBtn.draw();
    }
    if (this.drawScore) {
      textAlign(CENTER);
      textSize(40);
      text("You lose !", windowWidth / 2, 75);
      textSize(30);
      text("Your score : " + this.score, windowWidth / 2, 125);
    }
  }

  void updateScore() {
    this.score++;
    this.obstaclesGameSpeed += round(random(2));
    if (this.maxCoolDown > 50) {
      this.maxCoolDown -= round(random(5));
    }
  }
}

public class Square {
  SquareGame squareGame = sg;
  float x = 100, y = 400, size = 50;
  float speed = 0;
  boolean canJump = false;
  final float gravityMultiplicator = 0.2;
  final float jumpSpeed = 35;
  final float gravity = 5;

  void update(boolean jumpPress) {
    this.jump(jumpPress);
    this.gravity();
    this.draw();
  }

  void jump(boolean jump) {
    boolean asJump = false;
    if (this.canJump) {
      if (jump) {
        this.speed = this.jumpSpeed;
        this.canJump = false;
        asJump = true;
        file.play();
      }
    }
    if (!asJump) {
      if (this.speed > 0) {
        this.speed -= 2;
      } else {
        this.speed *= 1.2;
      }
    }
    this.y -= this.speed;
  }

  void gravity() {
    this.y += this.gravity;
  }

  void draw() {
    fill(255);
    if (this.y + this.size > squareGame.bottom) {
      this.y = squareGame.bottom - this.size;
      this.canJump = true;
      this.speed = 0;
    }
    for (int i = 0; i < squareGame.obstacles.size(); i++) {
      Obstacle ob = squareGame.obstacles.get(i);
      if ((ob.getX() <= this.x + this.size && ob.getX() + ob.getSize() >= this.x) && (ob.getY() <= this.y + this.size)) {
        squareGame.endGame();
      }
    }
    stroke(#FFFFFF);
    strokeWeight(2);
    fill(#000000);
    rect(this.x, this.y, this.size, this.size);
    image(playerSquarePng, this.x, this.y);
  }
}

public class Obstacle {
  SquareGame squareGame;
  float x, y, size, gameSpeed;
  float[] colors = {random(255), random(255), random(255)};
  Obstacle(float x, float y, float gameSpeed, SquareGame squareGame) {
    this.x = x;
    this.y = y;
    this.size = random(20, 50);
    this.y -= this.size;
    this.squareGame = squareGame;
    this.gameSpeed = gameSpeed;
  }

  float getX() {
    return this.x;
  }

  float getY() {
    return this.y;
  }

  float getSize() {
    return this.size;
  }

  boolean update() {
    if (this.x + this.size >= 0) {
      this.x -= this.gameSpeed;
      this.draw();
      return true;
    } else {
      return false;
    }
  }

  private void setNewColors() {
    float colorOne = this.colors[0];
    float colorTwo = this.colors[1];
    float colorThr = this.colors[2];
    colorOne = colorOne + random(-20, 20);
    if (colorOne < 0) colorOne = 0;
    else if (colorOne > 255) colorOne = 255;
    colorTwo = colorTwo + random(-20, 20);
    if (colorTwo < 0) colorTwo = 0;
    else if (colorTwo > 255) colorTwo = 255;
    colorThr = colorThr + random(-20, 20);
    if (colorThr < 0) colorThr = 0;
    else if (colorThr > 255) colorThr = 255;
    this.colors[0] = round(colorOne);
    this.colors[1] = round(colorTwo);
    this.colors[2] = round(colorThr);
  }

  void draw() {
    this.setNewColors();
    stroke(#FFFFFF);
    strokeWeight(1);
    fill(this.colors[0], this.colors[1], this.colors[2]);
    rect(this.x, this.y, this.size, this.size);
    image(obstaclesPng, this.x, this.y, this.size, this.size);
  }
}
