import processing.sound.*;

int windowWidth, windowHeight; // Déclaration de la variable pour contenir la longueur de la fenêtre && Déclaration de la variable pour contenir la hauteur de la fenêtre
Button startBtn; // Déclaration du bouton de départ
Button squareGameBtn; // Déclaration du bouton du jeu : SquareGame
Button geometryDashGameBtn; // Déclaration du bouton du jeu : GeometryDash
Button avoidCarsBtn; // Déclaration du bouton du jeu : AvoidCars
Button menuBtn; // Déclaration du bouton pour le menu
SquareGame sg = new SquareGame(); // Déclaration de l'instance du SquareGame
final String squareGameName = "SquareGame"; // Déclaration et initialisation du nom du SquareGame
GeometryDashGame gdg = new GeometryDashGame(); // Déclaration et initialisation du GeometryDashGame
final String geometryDashGameName = "GeometryDashGame"; // Déclaration et initialisation du nom du GeometryDashGame
AvoidCars avoidCars = new AvoidCars();
final String avoidCarsName = "Avoid Cars";
JSONObject jsonLevel;

/* SquareGame */
PImage playerSquarePng;
PImage obstaclesPng;
SoundFile file;

/* Avoid Cars */
PImage playerCar;
PImage[] botCars;

String gameActualName; // Déclaration du String qui stocke le nom du jeu auquelle l'utilisateur joue

void setWindowTitle(String title) { // Procédure pour changer le nom de la fenêtre
  surface.setTitle(title + " | Mathéo G. & Rudy B."); // Changement du nom de la fenêtre
}

void setup() { // Procédure principal d'initialisation
  setWindowTitle("Accueil"); // Changement du nom de la fenêtre
  size(1000, 900); // Création de la fenêtre avec la taille demandé
  windowWidth = width; // Récupération de la longueur de la fenêtre
  windowHeight = height; // Récupération de la hauteur de la fenêtre
  jsonLevel = loadJSONObject("geometryDashGameLevel.json"); // Chargement du level JSON
  playerSquarePng = loadImage("data/squarePng.png"); // Chargement de l'image du joueur de SquareGame
  obstaclesPng = loadImage("data/monsterPng.png"); // Chargement de l'image des ennemis de SquareGame
  file = new SoundFile(this, "squareJumpSound.wav"); // Chargement du sond de saut du joueur de SquareGame
  playerCar = loadImage("data/playerCar.png"); // Chargement de l'image du joueur de Avoid Cars
  botCars = new PImage[]{loadImage("data/botCar_green.png"), loadImage("data/botCar_orange.png"), loadImage("data/botCar_police.png"), loadImage("data/botCar_purple.png"), loadImage("data/botCar_red.png")};
  initBtns(); // Appelle de la procédure d'initialisation et de déclaration des boutons
  sg.init(); // Appelle de la procédure d'initialisation du Square Game
  gdg.init(); // Appelle de la procédure d'initialisation du GeometrieDach
  avoidCars.init(); // Appelle de la procédure d'initialisation du Avoid Cars
}

void initBtns() {
  startBtn = new Button(0, 0, 200, 100, "Menu", true); // Initialisation du bouton start
  startBtn.setVisibility(true); // Pour rendre le bouton visible dans l'espace de dessin
  menuBtn = new Button(0, 0, 150, 75, "Menu", true); // Initialisation du bouton pour accéder au menu des jeux
  squareGameBtn = new Button((windowWidth / 2) - (150 / 2), 75, 150, 75, "SquareGame", false); // Initialisation du bouton du SquareGame
  geometryDashGameBtn = new Button((windowWidth / 2) - (150 / 2), 195, 150, 75, "GeometryDash", false); // Initialisation du bouton du GeometryDash
  avoidCarsBtn = new Button(windowWidth / 2, 0, 150, 75, "Avoid Cars", true); // Initialisation du bouton du Avoid Cars
}

void draw() {
  frameRate(60); // Set du framerate
  clear(); // on essuie l'espace de dessin
  drawBtn(); // On appelle la fonction pour dessiner les boutons
  if (focused) { // Si la fenêtre a le focus
    sg.update(); // Update du SquareGame -> Si il est démarré
    gdg.update(); // Update du GeometryDashGame -> Si il est démarré
    avoidCars.update(); // Update du Avoid Cars -> Si il est démarré
  }
}

void drawBtn() { // Procédure d'appelle de procédure de dessin des boutons
  background(0); // Réinitialisation du fond
  startBtn.draw(); // Appelle la procédure de dessin du bouton "start"
  menuBtn.draw(); // Appelle la procédure de dessin du bouton "Menu"
  squareGameBtn.draw(); // Appelle la procédure de dessin du bouton "squareGame"
  geometryDashGameBtn.draw(); // Appelle la procédure de dessin du bouton "geometryDashGame"
  avoidCarsBtn.draw(); // Appelle la procédure de dessin du bouton "avoidCars"
}

void mousePressed() { // Procédure général qui est appellé lors d'un click de souris et qui appelle tout les autres
  if (startBtn.isClickOnMe(mouseX, mouseY)) { // Si le bouton "start" se fait cliquer dessus
    startBtn.setVisibility(false); // On rend invisible le bouton de "start"
    drawMenu(true); // Et on affiche le menu
    gameActualName = ""; // On vide le jeu actuel
  } else if (menuBtn.isClickOnMe(mouseX, mouseY)) {
    menuBtn.setVisibility(false);
    drawMenu(true);
    gameActualName = "";
    this.stopGame();
  } else if (squareGameBtn.isClickOnMe(mouseX, mouseY)) { // Si le bouton de "squareGame" se fait cliquer dessus
    drawMenu(false);
    sg.launch(); // On lance le jeu
    gameActualName = squareGameName; // Et on dis que le nom du jeu actuel est le nom du SquareGame
  } else if (geometryDashGameBtn.isClickOnMe(mouseX, mouseY)) {
    drawMenu(false);
    gdg.launch(); // On lance le jeu
    gameActualName = geometryDashGameName;
  } else if (avoidCarsBtn.isClickOnMe(mouseX, mouseY)) {
    drawMenu(false);
    avoidCars.launch();
    gameActualName = avoidCarsName;
  }
}

void keyPressed() {
  avoidCars.keyPressed(key);
}

void keyReleased() {
  avoidCars.keyReleased(key);
}

void stopGame() {
  sg.stop(); // Stop le SquareGame -> Si il est démmaré
  gdg.stop(); // Stop le GeometrieDach -> Si il est démarré
  avoidCars.stop(); // Stop le Avoid Cars -> Si il est démarré
}

void drawMenu(boolean show) {
  squareGameBtn.setVisibility(show);
  geometryDashGameBtn.setVisibility(show);
  avoidCarsBtn.setVisibility(show);
  if (show) {
    gameActualName = "";
    setWindowTitle("Menu");
  }
}

class Button { // Classe de bouton
  float x, y, width, height, borderRadius = 10; // Déclaration et initialisation des attributs
  String textContent; // Déclaration et initialisation des attributs
  boolean isVisible = false; // Déclaration et initialisation des attributs
  Button (float x, float y, float width, float height, String textContent, boolean center) { // Construteur
    this.width = width; // Association de la longueur
    this.height = height; // Association de la hauteur
    if (center) { // Si le bouton doit être centré par rapport à la fenêtre
      this.x = (windowWidth / 2) - (this.width / 2); // Position du X centré
      this.y = (windowHeight / 2) - (this.height / 2); // Position du Y centré
    } else { // Sinon le bouton à déjà une place précise
      this.x = x; // Association du X
      this.y = y; // Association du Y
    }
    this.textContent = textContent; // Association du texte du bouton
  }

  boolean isClickOnMe(float mouseX, float mouseY) { // Fonction qui retourne si c'est sur ce bouton que l'on a cliqué
    return (this.isVisible && mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height);
  }

  boolean getVisibility() {
    return this.isVisible;
  }

  void setVisibility(boolean visiblity) { // Procédure qui mets le bouton en visible ou non
    if (visiblity) { // Si on veut le bouton visible
      this.draw(); // Alors on le dessine
    }
    this.isVisible = visiblity; // On associe la nouvelle valeur
  }

  void draw() {
    if (this.isVisible) { // Si le bouton peux être visible
      rectMode(CORNER);
      stroke(107, 217, 62); // Définition de la couleur du contour
      strokeWeight(2); // Définition de la grosseur du contour
      fill(123, 227, 67); // Définition de la couleur de remplissage
      rect(this.x, this.y, this.width, this.height, this.borderRadius); // On déssine la forme du bouton
      fill(#FFFFFF); // Définition de la couleur de remplissage
      textSize(20); // Définition de la taille du texte
      textAlign(CENTER, CENTER); // Alignement du texte
      text(this.textContent, this.x + (this.width / 2), this.y + (this.height / 2)); // On écrit le texte
    }
  }
}
