public class GeometryDashGame {
	private JSONObject levelOne;
	private Player player;
	private int bottom, size = 40;
	private boolean started = false, drawScore = false, win = false;
	private float speedGame = 7, end, score;
	ArrayList<Plateform> plateforms;
  ArrayList<Pic> pics;
  Floor floor;
  Button restartBtn;
  public final float baseX = 800;
  public float baseY;

  void init() {
    plateforms = new ArrayList<Plateform>();
    pics = new ArrayList<Pic>();
    pics.add(new Pic(0, 0, this.size, this));
    levelOne = jsonLevel.getJSONObject("levels").getJSONObject("1");
    bottom = levelOne.getInt("floor");
    end = this.baseX + (levelOne.getInt("end") * this.size);
    score = 0;
    floor = new Floor(this.bottom, this.size, this);
    restartBtn = new Button((windowWidth / 2) - 150 / 2, 200, 150, 75, "Rejouer", false);
    this.baseY = this.bottom - this.size;
    loadJSONLevel(levelOne);
    player = new Player(50.0, bottom, this.size, 2.0, this);
  }

  void loadJSONLevel(JSONObject jsonLevel) {
    JSONArray jsonPlateforms = jsonLevel.getJSONArray("plateforms");
    for (int i = 0; i < jsonPlateforms.size(); i++) {
      JSONObject j = jsonPlateforms.getJSONObject(i);
      this.plateforms.add(new Plateform(this.baseX + (j.getFloat("x") * this.size), this.baseY - (j.getFloat("y") * this.size), this.size, this));
    }
    JSONArray jsonPics = jsonLevel.getJSONArray("pics");
    for (int i = 0; i < jsonPics.size(); i++) {
      JSONObject p = jsonPics.getJSONObject(i);
      this.pics.add(new Pic(this.baseX + (p.getFloat("x") * this.size), this.baseY - (p.getFloat("y") * this.size), this.size, this));
    }
  }

  void launch() {
    rectMode(CENTER);
    setWindowTitle("Geometrie Dach");
    this.start();
  }

  void start() {
    this.started = true;
  }

  void update() {
    if (this.started) {
      background(#2335B0);
      for (Plateform plateform : plateforms) {
        plateform.update();
      }
      this.floor.draw();
      for (Pic pic : pics) {
        pic.update();
      }
      this.player.update((keyPressed && (key == ' ') || mousePressed));
      this.score += this.speedGame;
    }
    if (this.drawScore) {
      textAlign(CENTER);
      fill(#FFFFFF);
      if (this.win) {
        textSize(50);
        text("You win !", windowWidth / 2, 100);
      } else {
        textSize(40);
        text("You lose !", windowWidth / 2, 100);
        text("Your score : " + Math.round((this.score / this.end) * 100) + "%", windowWidth / 2, 150);
      }
    }
    removePlateform();
    if (this.restartBtn.getVisibility()) {
      if (mousePressed) {
        if (this.restartBtn.isClickOnMe(mouseX, mouseY)) {
          this.restart();
        }
      }
      this.restartBtn.draw();
    }
  }

  void removePlateform() {
    for (int i = 0; i < this.plateforms.size(); i++) if (this.plateforms.get(i).x + this.plateforms.get(i).size < 0) this.plateforms.remove(i);
  }

  void stop() {
    this.started = false;
    this.drawScore = false;
    this.restartBtn.setVisibility(false);
  }

  void endGame() {
    rectMode(CORNER);
    this.started = false;
    this.drawScore = true;
    menuBtn.setVisibility(true);
    this.restartBtn.setVisibility(true);
  }

  void restart() {
    rectMode(CENTER);
    this.reset();
    this.restartBtn.setVisibility(false);
    menuBtn.setVisibility(false);
    this.drawScore = false;
    this.start();
  }

  void reset() {
    this.plateforms.clear();
    this.pics.clear();
    this.score = 0;
    this.win = false;
    this.loadJSONLevel(levelOne);
    this.player = new Player(50.0, bottom, this.size, 2.0, this);
  }
}

public class Player {
  private GeometryDashGame geometryDashGame;
  private float x, y, lastY, size, speed, counter = 0;
  private final float jumpSpeed = 25, gravity = 7;
  private boolean canJump = false, isInFly = false, isNotFall = false;

	/* ROTATION */

  private float rotate = 0;

  Player(float x, float y, float size, float speed, GeometryDashGame geometryDashGame) {
    this.x = x;
    this.y = y;
    this.size = size;
    this.speed = speed;
    this.geometryDashGame = geometryDashGame;
  }

  void update(boolean asJump) {
    this.jump(asJump);
    this.gravity();
	  this.animate();
    this.draw();
  }

	void jump(boolean jump) {
    boolean asJump = false;
    if (this.canJump && jump && this.isNotFall) {
      this.speed = this.jumpSpeed;
      this.canJump = false;
      asJump = true;
			isInFly = true;
		}
    if (!asJump) {
      if (this.speed > 0) {
        this.speed -= 2;
      } else {
        this.speed *= 1.3;
      }
    }
    this.y -= this.speed;
  }

  void gravity() {
    this.y += this.gravity;
  }

  void animate() {
	  if (isInFly) {
		  this.rotate += 15;
	  } else {
		  this.rotate = 0;
	  }
  }

  void draw() {
    this.isNotFall = false;
	  if (this.y + this.size > this.geometryDashGame.bottom) {
      this.y = this.geometryDashGame.bottom - this.size;
      this.canJump = true;
      this.speed = 0;
		  this.isInFly = false;
      this.isNotFall = true;
    }
    for (Plateform plate : this.geometryDashGame.plateforms) {
      if ((this.y + this.size >= plate.y && this.lastY + this.size <= plate.y) && (this.x + this.size > plate.x && this.x < plate.x + plate.size)) {
        this.y = plate.y - this.size;
        this.canJump = true;
        this.speed = 0;
        this.isInFly = false;
        this.isNotFall = true;
      } else {
        if ((this.x + this.size > plate.x && this.x < plate.x + plate.size) && this.y + this.size > plate.y) {
          geometryDashGame.endGame();
        }
      }
	  }
    for (Pic pic : this.geometryDashGame.pics) {
      if ((pic.x <= this.x + this.size && pic.x + pic.size >= this.x) && (pic.y <= this.y + this.size)) {
        geometryDashGame.endGame();
      }
    }
    if (this.geometryDashGame.score >= this.geometryDashGame.end) {
      this.geometryDashGame.win = true;
      geometryDashGame.endGame();
    }
    stroke(#FFFFFF);
    strokeWeight(2);
    fill(#000000);
	  translate(this.x, this.y);
	  rotate(map(this.rotate, 0, width, 0, TWO_PI));
	  rectMode(CENTER);
    rect(0, 0, this.size, this.size);
	  translate(0, 0);
    lastY = this.y;
  }
}

public class Plateform {
  private GeometryDashGame geometryDashGame;
  float x, y, size;
  public Plateform(float x, float y, float size, GeometryDashGame geometryDashGame) {
    this.size = size;
    this.x = x;
    this.y = y;
    this.geometryDashGame = geometryDashGame;
  }

  void update() {
    this.x -= geometryDashGame.speedGame;
    this.draw();
  }

  void draw() {
    stroke(#0C2C6A);
    strokeWeight(2);
    fill(#1633AD);
    rect(x, y, size, size);
  }
}

public class Floor {
  private GeometryDashGame geometryDashGame;
  float y, size;
  public Floor(float y, float size, GeometryDashGame geometryDashGame) {
    this.y = y;
    this.size = size;
    this.geometryDashGame = geometryDashGame;
  }

  void draw() {
    stroke(#0C2C6A);
    strokeWeight(2);
    fill(#1633AD);
    rect(0 + (windowWidth / 2), this.y, windowWidth, this.size);
  }
}

public class Pic {
  private GeometryDashGame geometryDashGame;
  float x, y, size;
  public Pic(float x, float y, float size, GeometryDashGame geometryDashGame) {
    this.x = x;
    this.y = y;
    this.size = size;
    this.x -= this.size / 2;
    this.y += this.size / 2;
    this.geometryDashGame = geometryDashGame;
  }

  void update() {
    this.x -= geometryDashGame.speedGame;
    this.draw();
  }

  void draw() {
    stroke(#0C2C6A);
    strokeWeight(2);
    fill(#1633AD);
    triangle(this.x, this.y, this.x + this.size / 2, this.y - this.size, this.x + this.size, this.y);
  }
}