import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.sound.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class main extends PApplet {



float windowWidth; // Déclaration de la variable pour contenir la longueur de la fenêtre
float windowHeight; // Déclaration de la variable pour contenir la hauteur de la fenêtre
Button startBtn; // Déclaration du bouton de départ
Button squareGameBtn; // Déclaration du bouton du jeu : SquareGame
Button geometryDashGameBtn; // Déclaration du bouton du jeu : GeometryDash
Button menuBtn; // Déclaration du bouton pour le menu
SquareGame sg = new SquareGame(); // Déclaration de l'instance du SquareGame
final String squareGameName = "SquareGame"; // Déclaration et initialisation du nom du SquareGame
GeometryDashGame gdg = new GeometryDashGame(); // Déclaration et initialisation du GeometryDashGame
final String geometryDashGameName = "GeometryDashGame"; // Déclaration et initialisation du nom du GeometryDashGame
JSONObject jsonLevel;

PImage playerSquarePng;
PImage obstaclesPng;
SoundFile file;

String gameActualName; // Déclaration du String qui stocke le nom du jeu auquelle l'utilisateur joue

public void setWindowTitle(String title) { // Procédure pour changer le nom de la fenêtre
  surface.setTitle(title + " | Mathéo G. & Rudy B."); // Changement du nom de la fenêtre
}

public void setup() { // Procédure principal d'initialisation
  setWindowTitle("Accueil"); // Changement du nom de la fenêtre
   // Création de la fenêtre avec la taille demandé
  windowWidth = width; // Récupération de la longueur de la fenêtre
  windowHeight = height; // Récupération de la hauteur de la fenêtre
  jsonLevel = loadJSONObject("geometryDashGameLevel.json");
  playerSquarePng = loadImage("data/squarePng.png");
  obstaclesPng = loadImage("data/monsterPng.png");
  file = new SoundFile(this, "squareJumpSound.wav");
  initBtns(); // Appelle de la procédure d'initialisation et de déclaration des boutons
  sg.init(); // Appelle de la procédure d'initialisation du Square Game
  gdg.init();
}

public void initBtns() {
  startBtn = new Button(0, 0, 200, 100, "Menu", true); // Initialisation du bouton start
  startBtn.setVisibility(true); // Pour rendre le bouton visible dans l'espace de dessin
  menuBtn = new Button(0, 0, 150, 75, "Menu", true);
  squareGameBtn = new Button((windowWidth / 2) - (150 / 2), 75, 150, 75, "SquareGame", false); // Initialisation du bouton du SquareGame
  geometryDashGameBtn = new Button((windowWidth / 2) - (150 / 2), 180, 150, 75, "GeometryDash", false); // Initialisation du bouton du GeometryDash
  geometryDashGameBtn.setVisibility(false);
}

public void draw() {
  frameRate(60);
  clear(); // on essuie l'espace de dessin
  drawBtn(); // On appelle la fonction pour dessiner les boutons
  if (focused) { // Si la fenêtre a le focus
    sg.update(); // Update du SquareGame -> Si il est démarré
    gdg.update(); // Update du GeometryDashGame -> Si il est démarré
  }
}

public void drawBtn() { // Procédure d'appelle de procédure de dessin des boutons
  startBtn.draw(); // Appelle la procédure de dessin du bouton "start"
  menuBtn.draw(); // Appelle la procédure de dessin du bouton "Menu"
  squareGameBtn.draw(); // Appelle la procédure de dessin du bouton "squareGame"
  geometryDashGameBtn.draw(); // Appelle la procédure de dessin du bouton "geometryDashGame"
}

public void mousePressed() { // Procédure général qui est appellé lors d'un click de souris et qui appelle tout les autres
  if (startBtn.isClickOnMe(mouseX, mouseY)) { // Si le bouton "start" se fait cliquer dessus
    startBtn.setVisibility(false); // On rend invisible le bouton de "start"
    drawMenu(true); // Et on affiche le menu
    gameActualName = ""; // On vide le jeu actuel
  } else if (menuBtn.isClickOnMe(mouseX, mouseY)) {
    menuBtn.setVisibility(false);
    drawMenu(true);
    gameActualName = "";
    this.stopGame();
  } else if (squareGameBtn.isClickOnMe(mouseX, mouseY)) { // Si le bouton de "squareGame" se fait cliquer dessus
    drawMenu(false);
    sg.launch(); // On lance le jeu
    gameActualName = squareGameName; // Et on dis que le nom du jeu actuel est le nom du SquareGame
  } else if (geometryDashGameBtn.isClickOnMe(mouseX, mouseY)) {
    drawMenu(false);
    gdg.launch();
    gameActualName = geometryDashGameName;
  }
}

public void stopGame() {
  sg.stop();
}

public void drawMenu(boolean show) {
  if (show) {
    gameActualName = "";
    setWindowTitle("Menu");
    squareGameBtn.setVisibility(true);
    geometryDashGameBtn.setVisibility(true);
  } else {
    squareGameBtn.setVisibility(false);
    geometryDashGameBtn.setVisibility(false);
  }
}

class Button { // Classe de bouton
  float x, y, width, height, borderRadius = 10; // Déclaration et initialisation des attributs
  String textContent; // Déclaration et initialisation des attributs
  boolean isVisible = false; // Déclaration et initialisation des attributs
  Button (float x, float y, float width, float height, String textContent, boolean center) { // Construteur
    this.width = width; // Association de la longueur
    this.height = height; // Association de la hauteur
    if (center) { // Si le bouton doit être centré par rapport à la fenêtre
      this.x = (windowWidth / 2) - (this.width / 2); // Position du X centré
      this.y = (windowHeight / 2) - (this.height / 2); // Position du Y centré
    } else { // Sinon le bouton à déjà une place précise
      this.x = x; // Association du X
      this.y = y; // Association du Y
    }
    this.textContent = textContent; // Association du texte du bouton
  }

  public boolean isClickOnMe(float mouseX, float mouseY) { // Fonction qui retourne si c'est sur ce bouton que l'on a cliqué
    return (this.isVisible && mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height);
  }

  public boolean getVisibility() {
    return this.isVisible;
  }

  public void setVisibility(boolean visiblity) { // Procédure qui mets le bouton en visible ou non
    if (visiblity) { // Si on veut le bouton visible
      this.draw(); // Alors on le dessine
    }
    this.isVisible = visiblity; // On associe la nouvelle valeur
  }

  public void draw() {
    if (this.isVisible) { // Si le bouton peux être visible
      stroke(107, 217, 62); // Définition de la couleur du contour
      strokeWeight(2); // Définition de la grosseur du contour
      fill(123, 227, 67); // Définition de la couleur de remplissage
      rect(this.x, this.y, this.width, this.height, this.borderRadius); // On déssine la forme du bouton
      fill(0xffFFFFFF); // Définition de la couleur de remplissage
      textSize(20); // Définition de la taille du texte
      textAlign(CENTER, CENTER); // Alignement du texte
      text(this.textContent, this.x + (this.width / 2), this.y + (this.height / 2)); // On écrit le texte
    }
  }
}
public class GeometryDashGame {
  private JSONObject levelOne;
  private Player player;
  private int bottom;
  private boolean started = false;
  private int speedGame = 1;
  private ArrayList<Plateform> plateforms;

  public void init() {
    plateforms = new ArrayList<Plateform>();
    levelOne = jsonLevel.getJSONObject("levels").getJSONObject("1");
    bottom = levelOne.getInt("floor");
    JSONArray plateforms = levelOne.getJSONArray("plateforms");
    for (int i = 0; i < plateforms.size(); i++) {
      JSONObject j = plateforms.getJSONObject(i);
      this.plateforms.add(new Plateform(j.getFloat("x"), j.getFloat("y"), this));
    }
    player = new Player(this);
  }

  public void launch() {
    setWindowTitle("Geometrie Dach");
    this.start();
  }

  public void start() {
    this.started = true;
  }

  public void update() {
    if (this.started) {
      background(0xff2335B0);
      for (Plateform plateform : plateforms) {
        plateform.update();
      }
    }
  }
}

public class Player {
  private GeometryDashGame geometryDashGame;

  Player(GeometryDashGame geometryDashGame) {
    this.geometryDashGame = geometryDashGame;
  }

  public void update() {

  }

  public void draw() {

  }
}

public class Plateform {
  private GeometryDashGame geometryDashGame;
  private float x, y, size = 50;
  public Plateform(float x, float y, GeometryDashGame geometryDashGame) {
    this.x = x;
    this.y = y;
    this.geometryDashGame = geometryDashGame;
  }

  public void update() {
    this.x -= geometryDashGame.speedGame;
    this.draw();
  }

  public void draw() {
    stroke(0xff0C2C6A);
    strokeWeight(2);
    fill(0xff1633AD);
    rect(x, y, size, size);
  }
}
public class SquareGame {
  Square playerSquare;
  ArrayList<Obstacle> obstacles;
  boolean started = false, drawScore = false;
  int score, baseMaxCoolDown, maxCoolDown, cooldown, baseObstaclesGameSpeed, obstaclesGameSpeed, bottom;
  Button restartBtn;

  public void init() {
    this.playerSquare = new Square();
    this.obstacles = new ArrayList<Obstacle>();
    this.restartBtn = new Button((windowWidth / 2) - 150 / 2, 30, 150, 75, "Rejouer", false);
    this.score = 0;
    this.baseMaxCoolDown = 150;
    this.maxCoolDown = this.baseMaxCoolDown;
    this.baseObstaclesGameSpeed = 5;
    this.obstaclesGameSpeed = this.baseObstaclesGameSpeed;
    this.cooldown = this.baseMaxCoolDown;
    this.bottom = 400;
  }

  public void launch() {
    setWindowTitle("Square Game");
    this.start();
  }

  public void start() {
    this.started = true;
  }

  public void restart() {
    this.reset();
    this.restartBtn.setVisibility(false);
    menuBtn.setVisibility(false);
    this.drawScore = false;
    this.start();
  }

  public void reset() {
    this.obstacles.clear();
    this.maxCoolDown = this.baseMaxCoolDown;
    this.cooldown = this.baseMaxCoolDown;
    this.obstaclesGameSpeed = this.baseObstaclesGameSpeed;
    this.score = 0;
    this.playerSquare = new Square();
  }

  public void endGame() {
    this.started = false;
    this.drawScore = true;
    this.restartBtn.setVisibility(true);
    menuBtn.setVisibility(true);
  }

  public void stop() {
    this.reset();
    this.started = false;
    this.drawScore = false;
    this.restartBtn.setVisibility(false);
  }

  public void update() {
    if (this.started) {
      if (this.cooldown < 1) {
        this.obstacles.add(new Obstacle(windowWidth, this.bottom, this.obstaclesGameSpeed, this));
      }
      this.playerSquare.update((keyPressed && (key == ' ') || mousePressed));
      for (int i = 0; i < this.obstacles.size(); i++) {
        if (!this.obstacles.get(i).update()){
          this.obstacles.remove(i);
          this.updateScore();
        }
      }
      if (this.cooldown > 0) this.cooldown--;
      else this.cooldown = round(random(50, this.maxCoolDown));
    }
    if (this.restartBtn.getVisibility()) {
      if (mousePressed) {
        if (this.restartBtn.isClickOnMe(mouseX, mouseY)) {
          this.restart();
        }
      }
      this.restartBtn.draw();
    }
    if (this.drawScore) {
      textAlign(CENTER);
      textSize(40);
      text("You lose !", windowWidth / 2, 350);
      textSize(30);
      text("Your score : " + this.score, windowWidth / 2, 400);
    }
  }

  public void updateScore() {
    this.score++;
    this.obstaclesGameSpeed += round(random(2));
    if (this.maxCoolDown > 50) {
      this.maxCoolDown -= round(random(5));
    }
  }
}

public class Square {
  SquareGame squareGame = sg;
  float x = 100, y = 200, size = 50;
  float speed = 0;
  boolean canJump = false;
  final float gravityMultiplicator = 0.2f;
  final float jumpSpeed = 35;
  final float gravity = 5;

  public void update(boolean jumpPress) {
    this.jump(jumpPress);
    this.gravity();
    this.draw();
  }

  public void jump(boolean jump) {
    boolean asJump = false;
    if (this.canJump) {
      if (jump) {
        this.speed = this.jumpSpeed;
        this.canJump = false;
        asJump = true;
        file.play();
      }
    }
    if (!asJump) {
      if (this.speed > 0) {
        this.speed -= 2;
      } else {
        this.speed *= 1.2f;
      }
    }
    this.y -= this.speed;
  }

  public void gravity() {
    this.y += this.gravity;
  }

  public void draw() {
    fill(255);
    if (this.y + this.size > squareGame.bottom) {
      this.y = squareGame.bottom - this.size;
      this.canJump = true;
      this.speed = 0;
    }
    for (int i = 0; i < squareGame.obstacles.size(); i++) {
      Obstacle ob = squareGame.obstacles.get(i);
      if ((ob.getX() <= this.x + this.size && ob.getX() + ob.getSize() >= this.x) && (ob.getY() <= this.y + this.size)) {
        squareGame.endGame();
      }
    }
    stroke(0xffFFFFFF);
    strokeWeight(2);
    fill(0xff000000);
    rect(this.x, this.y, this.size, this.size);
    image(playerSquarePng, this.x, this.y);
  }
}

public class Obstacle {
  SquareGame squareGame;
  float x, y, size, gameSpeed;
  float[] colors = {random(255), random(255), random(255)};
  Obstacle(float x, float y, float gameSpeed, SquareGame squareGame) {
    this.x = x;
    this.y = y;
    this.size = random(20, 50);
    this.y -= this.size;
    this.squareGame = squareGame;
    this.gameSpeed = gameSpeed;
  }

  public float getX() {
    return this.x;
  }

  public float getY() {
    return this.y;
  }

  public float getSize() {
    return this.size;
  }

  public boolean update() {
    if (this.x + this.size >= 0) {
      this.x -= this.gameSpeed;
      this.draw();
      return true;
    } else {
      return false;
    }
  }

  private void setNewColors() {
    float colorOne = this.colors[0];
    float colorTwo = this.colors[1];
    float colorThr = this.colors[2];
    colorOne = colorOne + random(-20, 20);
    if (colorOne < 0) colorOne = 0;
    else if (colorOne > 255) colorOne = 255;
    colorTwo = colorTwo + random(-20, 20);
    if (colorTwo < 0) colorTwo = 0;
    else if (colorTwo > 255) colorTwo = 255;
    colorThr = colorThr + random(-20, 20);
    if (colorThr < 0) colorThr = 0;
    else if (colorThr > 255) colorThr = 255;
    this.colors[0] = round(colorOne);
    this.colors[1] = round(colorTwo);
    this.colors[2] = round(colorThr);
  }

  public void draw() {
    this.setNewColors();
    stroke(0xffFFFFFF);
    strokeWeight(1);
    fill(this.colors[0], this.colors[1], this.colors[2]);
    rect(this.x, this.y, this.size, this.size);
    image(obstaclesPng, this.x, this.y, this.size, this.size);
  }
}
  public void settings() {  size(700, 500); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "main" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
