public class AvoidCars {
    private Button restartBtn = new Button(425, 200, 150, 75, "Rejouer", false);
    private int score = 0, nbParty = 1, maxScore = 0, gameHeight = 900, carSize = 50;
    private boolean started = false, ended = false;
    private PlayerCar playerCar;
    private Road road;
    private Circulation circulation;

    void init() {
        playerCar = new PlayerCar(625, 600, this.carSize, this);
        road = new Road(this);
        circulation = new Circulation(this);
    }

    void launch() {
      this.start();
      setWindowTitle("Avoid Cars");
    }

    void start() {
      rectMode(CORNER);
      this.started = true;
      this.restartBtn.setVisibility(false);
    }

    void update() {
      if (this.started) {
        road.update();
        circulation.update();
        playerCar.update();
        text("Score : " + score, 50, 40);
        text("Max : " + maxScore, 50, 140);
      }
      if (this.ended) {
        text("Score : " + score, 50, 40);
        text("Max : " + maxScore, 50, 140);
      }
      if (this.restartBtn.getVisibility()) {
        if (mousePressed) {
          if (this.restartBtn.isClickOnMe(mouseX, mouseY)) {
            this.restart();
          }
        }
        this.restartBtn.draw();
      }
    }

    void endGame() {
      rectMode(CORNER);
      this.maxScore = (this.score > this.maxScore) ? this.score : this.maxScore;
      this.started = false;
      this.ended = true;
      menuBtn.setVisibility(true);
      this.restartBtn.setVisibility(true);
    }

    void stop() {
      this.started = false;
      this.ended = false;
      this.restartBtn.setVisibility(false);
    }

    void restart() {
      playerCar = new PlayerCar(625, 600, this.carSize, this);
      road = new Road(this);
      circulation = new Circulation(this);
      this.score = 0;
      this.start();
    }

    void keyPressed(char key) {
        if (key == 'z') playerCar.setDirection(0, true);
        else if (key == 'd') playerCar.setDirection(1, true);
        else if (key == 's') playerCar.setDirection(2, true);
        else if (key == 'q') playerCar.setDirection(3, true);
    }

    void keyReleased(char key) {
        if (key == 'z') playerCar.setDirection(0, false);
        else if (key == 'd') playerCar.setDirection(1, false);
        else if (key == 's') playerCar.setDirection(2, false);
        else if (key == 'q') playerCar.setDirection(3, false);
    }

    int getGameHeight() {return this.gameHeight;}
    PlayerCar getPlayerCar() {return this.playerCar;}
    Road getRoad() {return this.road;}
    Circulation getCirculation() {return this.circulation;}
    int getScore() {return this.score;}
    void setScore(int score) {this.score = score;}
    int getCarSize() {return this.carSize;}
}

public class PlayerCar {
    private AvoidCars avoidCars;
    private float x, y, size, speed = 0.05, gravity = 0.05, invicibility = 300;
    private float velocityXn = 0, velocityXp = 0, velocityYn = 0, velocityYp = 0;
    private final float speedMaxA = 15, speedMaxT = 4;
    private boolean[] directions = {false,false,false,false};

    public PlayerCar(float x, float y, float size, AvoidCars avoidCars) {
        this.x = x;
        this.y = y;
        this.size = size;
        this.avoidCars = avoidCars;
    }

    void update() {
      for (BotCar botCar : this.avoidCars.getCirculation().getBotCars()) {
        if (this.x < botCar.getX() + botCar.getSize() && this.x + this.size > botCar.getX() && this.y < botCar.getY() + botCar.getSize() && this.y + this.size > botCar.getY()) {
          if (this.invicibility <= 0) this.avoidCars.endGame();
        }
      }
      if (this.directions[0] && velocityYn <= speedMaxA) velocityYn += this.speed;
      else {
        if (velocityYn > gravity) velocityYn -= gravity;
        else velocityYn = 0;
      }
      if (this.directions[1] && velocityXp <= speedMaxT) velocityXp += this.speed;
      else {
        if (velocityXp > gravity) velocityXp -= gravity;
        else velocityXp = 0;
      }
      if (this.directions[2] && velocityYp <= speedMaxA) velocityYp += this.speed * 2.5;
      else {
        if (velocityYp > gravity) velocityYp -= gravity;
        else velocityYp = 0;
      }
      if (this.directions[3] && velocityXn <= speedMaxT) velocityXn += this.speed;
      else {
        if (velocityXn > gravity) velocityXn -= gravity;
        else velocityXn =0;
      }
      x += velocityXp;
      x -= velocityXn;
      if (this.invicibility > 0) this.invicibility--;
      if (this.x < 300) {
        this.x = 300;
        this.velocityXn = 0;
      } else if (this.x + this.size > 675) {
        this.x = 675 - this.size;
        this.velocityXp = 0;
      }
      this.draw();
    }

    void draw() {
      imageMode(CORNER);
      if (this.invicibility > 0) {
        if (this.invicibility % 2 == 0) {
          fill(255);
          rect(this.x, this.y, this.size, this.size);
        } else {
          image(playerCar, this.x, this.y, this.size, this.size);
        }
      } else {
        image(playerCar, this.x, this.y, this.size, this.size);
      }
    }

    void setDirection(int i, boolean value) {this.directions[i] = value;}

    float getX() {return this.x;}
    float getY() {return this.y;}
    float getVelocityYn() {return this.velocityYn;}
    float getVelocityYp() {return this.velocityYp;}
}

public class Circulation {
  private AvoidCars avoidCars;
  private ArrayList<BotCar> botCars;

  public Circulation(AvoidCars avoidCars) {
    this.avoidCars = avoidCars;
    botCars = generateBotCars();
  }

  void update() {
    for (BotCar botCar : botCars) {
      if (botCar.getY() + botCar.getSize() < 0) {
        botCar.setY(this.avoidCars.getGameHeight());
        if (!botCar.getInvers()) this.avoidCars.setScore(this.avoidCars.getScore() - 1);
      }
      else if (botCar.getY() > this.avoidCars.getGameHeight()) {
        botCar.setY(0 - botCar.getSize());
        if (!botCar.getInvers()) this.avoidCars.setScore(this.avoidCars.getScore() + 1);
      }
      botCar.update();
    }
  }

  ArrayList<BotCar> generateBotCars() {
    ArrayList<BotCar> botCars = new ArrayList<BotCar>();
    for (int i = this.avoidCars.getGameHeight(); i > -this.avoidCars.getCarSize(); i -= 5 * 100) {
      botCars.add(new BotCar(this.avoidCars.getRoad().getVOIE(1), i, this.avoidCars.getCarSize(), true, this.avoidCars));
      botCars.add(new BotCar(this.avoidCars.getRoad().getVOIE(2), i, this.avoidCars.getCarSize(), true, this.avoidCars));
      botCars.add(new BotCar(this.avoidCars.getRoad().getVOIE(3), i, this.avoidCars.getCarSize(), false, this.avoidCars));
      botCars.add(new BotCar(this.avoidCars.getRoad().getVOIE(4), i, this.avoidCars.getCarSize(), false, this.avoidCars));
    }
    return botCars;
  }

  ArrayList<BotCar> getBotCars() {return this.botCars;}
}

public class BotCar {
  private AvoidCars avoidCars;
  private float x, y, size, speed;
  private boolean invers;
  PImage botImage;

  public BotCar(float x, float y, float size, boolean invers, AvoidCars avoidCars) {
    this.x = x;
    this.y = y;
    this.size = size;
    this.invers = invers;
    this.avoidCars = avoidCars;
    this.getSpeed();
    this.botImage = botCars[Math.round(random(0, 4))];
  }

  void update() {
    if (invers) {
      y += this.speed + avoidCars.getPlayerCar().getVelocityYn();
      y -= avoidCars.getPlayerCar().getVelocityYp();
    } else {
      y += avoidCars.getPlayerCar().getVelocityYn();
      y -= this.speed + avoidCars.getPlayerCar().getVelocityYp();
    }
    
    this.draw();
  }

  void draw() {
    image(botImage, x, y, size, size);
  }

  void getSpeed() {
    if (this.x == this.avoidCars.getRoad().getVOIE(2) || this.x == this.avoidCars.getRoad().getVOIE(3)) this.speed = 5;
    else this.speed = 3;
  }

  float getX() {return this.x;}
  float getY() {return this.y;}
  void setY(float y) {this.y = y;}
  float getSize() {return this.size;}
  boolean getInvers() {return this.invers;}
}

public class Road {
  private AvoidCars avoidCars;
  private ArrayList<RoadLine> roadLines;
  private final float VOIE_1 = 315, VOIE_2 = 410, VOIE_3 = 510, VOIE_4 = 615;
  private final float MIDDLE_1 = 380, MIDDLE_2 = 580;

  public Road(AvoidCars avoidCars) {
    this.avoidCars = avoidCars;
    roadLines = getRoadLine();
  }

  void update() {
    float min = windowHeight, max = -this.avoidCars.getCarSize();
    for (int i = 0; i < roadLines.size(); i++) {
      RoadLine roadLine = roadLines.get(i);
      if (roadLine.getY() > height || roadLine.getY() + this.avoidCars.getCarSize() < 0) roadLines.remove(i);
      else {
        if (roadLine.getY() < min) min = roadLine.getY();
        if (roadLine.getY() + this.avoidCars.getCarSize() > max) max = roadLine.getY() + this.avoidCars.getCarSize();
      }
    }
    if (min >= 0) {
      roadLines.add(new RoadLine(MIDDLE_1, -this.avoidCars.getCarSize(), this.avoidCars));
      roadLines.add(new RoadLine(MIDDLE_2, -this.avoidCars.getCarSize(), this.avoidCars));
    }
    if (max < height) {
      roadLines.add(new RoadLine(MIDDLE_1, windowHeight, this.avoidCars));
      roadLines.add(new RoadLine(MIDDLE_2, windowHeight, this.avoidCars));
    }
    this.draw();
  }

  void draw() {
    noStroke();
    background(#209b20);
    fill(#473e3e);
    rect(300, 0, 375, windowHeight);
    fill(#FFFFFF);
    rect(470, 0, 10, windowHeight);
    rect(490, 0, 10, windowHeight);
    for (RoadLine roadLine : roadLines) {
      roadLine.draw();
    }
  }

  ArrayList<RoadLine> getRoadLine() {
    ArrayList<RoadLine> roadLines = new ArrayList<RoadLine>();
    for (int i = windowHeight; i > - 40; i -= 10 + 40) {
      roadLines.add(new RoadLine(MIDDLE_1, i, this.avoidCars));
      roadLines.add(new RoadLine(MIDDLE_2, i , this.avoidCars));
    }
    return roadLines;
  }

  public float getVOIE(int number) {
    if (number == 1) return VOIE_1;
    else if (number == 2) return VOIE_2;
    else if (number == 3) return VOIE_3;
    else if (number == 4) return VOIE_4;
    else return 0;
  }
}

public class RoadLine {
  private AvoidCars avoidCars;
  private float x, y, width = 10, height = 40, speed = 0;
  public RoadLine(float x, float y, AvoidCars avoidCars){
    this.x = x;
    this.y = y;
    this.avoidCars = avoidCars;
  }

  public void draw() {
    y += speed + avoidCars.getPlayerCar().getVelocityYn();
    y -= speed + avoidCars.getPlayerCar().getVelocityYp();
    rect(x, y, width, height);
  }
  
  public float getY() {return y;}
}